// spreadsheet関連util

/**
 * spreedsheetから取得した授業一覧から、チャンネル未作成の授業のみリスト化
 *
 * 前提として授業名は一意である必要あり
 */
export const makeUnregisteredLessonList = (
  sheetLessons: string[][] | null | undefined
): { id: string; name: string }[] => {
  // [[lessonName, channelID], ....]
  if (!sheetLessons) return [];

  return sheetLessons
    .filter((lesson) => !lesson[1])
    .map((lesson) => {
      return { id: lesson[0], name: lesson[0] };
    });
};
